/*
 *  CDGL_IDirect3DSurface9_Tex.h
 *  RoboDXGL
 *
 *  Created by Shilpa Prabhu on Tue Nov 30 2004.
 *  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
 *
 */

#ifndef __CDGL_IDIRECT3DSURFACE9_H__
#define __CDGL_IDIRECT3DSURFACE9_H__

#include <Carbon/Carbon.h>
#include "DXGraphics.h"
#include "CDGL_IDirect3DTexture9.h"
#include "CDGL_IDirect3DSurface9.h"

//! This is an additional class introduced to represent a surface (a mip level) in a texture.
class CDGL_IDirect3DSurface9_Tex : public CDGL_IDirect3DSurface9
{

	public:
	
	CDGL_IDirect3DSurface9_Tex(CDGL_IDirect3DTexture9 *pTex, UINT in_nLevel);
	~CDGL_IDirect3DSurface9_Tex();
	
	HRESULT LockRect(D3DLOCKED_RECT *pLockedRect, CONST RECT *pRect, DWORD Flags);
	ULONG   Release();
	HRESULT UnlockRect();
	HRESULT GetContainer(REFIID iid, void **ppContainer);
	 
	private:
	
	//! Member vaiables.
	
	//! This member variable holds pointer to the parant texture.
	CDGL_IDirect3DTexture9	*	m_pTex;
	//! Thsi variable represents to which mip level of the parent texture this surface corresponds.
	UINT						m_nLevel; 
	
};




#endif //__CDGL_IDIRECT3DSURFACE9_H__